const express = require("express");
const cors = require("cors");
const dotenv = require("dotenv");
const connectDB = require("./config/db");
const authRoutes = require("./routes/authRoutes");
const fileRoutes = require("./routes/fileRoutes");
const path = require("path");
const fs = require("fs");
const cron = require("node-cron");
const File = require("./models/File");

dotenv.config();
connectDB();

const app = express();
app.use(cors());
app.use(express.json());
app.use("/uploads", express.static(path.join(process.cwd(), "uploads")));

// Routes
app.use("/api/auth", authRoutes);
app.use("/api/file", fileRoutes);

// Auto delete expired files every minute
cron.schedule("* * * * *", async () => {
  const now = new Date();
  const expiredFiles = await File.find({ expiresAt: { $lt: now } });
  expiredFiles.forEach(async (file) => {
    if (fs.existsSync(file.path)) fs.unlinkSync(file.path);
    await file.deleteOne();
  });
  console.log(`Cleaned ${expiredFiles.length} expired files`);
});

const PORT = process.env.PORT || 5000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
